% Enkele simulatieparameters:
Samplerate = 1024;
Totaltime = 2.0;
Risetime = 1.0;
Carrierfreq = 8.0;
KernelFWHM = 0.05;

% Signalen simuleren:
time = (floor(-Totaltime*Samplerate/2):ceil(Totaltime*Samplerate/2))/Samplerate;
envelope = ones(size(time));
envelope(time < 0) = 0;
envelope((floor(-Risetime*Samplerate/2):ceil(Risetime*Samplerate/2))+Totaltime*Samplerate/2+1) ...
    = 0.5+0.5*sin(pi/2*(floor(-Risetime*Samplerate/2):ceil(Risetime*Samplerate/2))/Risetime/Samplerate*2);
signal = envelope.*cos(2*pi*Carrierfreq*time);
signal2 = signal + 0.3*signal.^3 + 0.03*signal.^5; %
H1=hilbert(signal2);                               %

% Amplitude bepalen d.m.v. convolutie:
coskernel = exp(-log(2)*(time/KernelFWHM).^2).*cos(2*pi*Carrierfreq*time);
coskernel = coskernel/(coskernel*cos(2*pi*Carrierfreq*time)');
sinkernel = exp(-log(2)*(time/KernelFWHM).^2).*sin(2*pi*Carrierfreq*time);
sinkernel = sinkernel/(sinkernel*sin(2*pi*Carrierfreq*time)');
amplitude = sqrt(conv2(signal2,coskernel,'same').^2+conv2(signal2,sinkernel,'same').^2); %

% Resultaten tonen:
plot(time,envelope,':k',time,-envelope,':k',time,signal2,'-b'...
    ,time,amplitude,'-r',time,-amplitude,'-r',time,abs(H1),'k');
